using System;
using System.Collections.Generic;

class Program
{
    static (int, List<int>) MaximizeExpression(int N, List<int> P)
    {
        List<int> Q = new List<int>();
        for (int i = 0; i <= N; i++)
        {
            Q.Add(P[i] | (1 << (int)Math.Floor(Math.Log(P[i], 2)) + 1));
        }

        int X = 0;
        for (int i = 0; i <= N; i++)
        {
            X += P[i] ^ Q[i];
        }

        return (X, Q);
    }

    static void Main(string[] args)
    {
        int T = int.Parse(Console.ReadLine());
        List<(int, List<int>)> results = new List<(int, List<int>)>();

        for (int t = 0; t < T; t++)
        {
            int N = int.Parse(Console.ReadLine());
            List<int> P = new List<int>(Array.ConvertAll(Console.ReadLine().Split(), int.Parse));

            var result = MaximizeExpression(N, P);
            results.Add(result);
        }

        foreach (var (X, Q) in results)
        {
            Console.WriteLine(X);
            Console.WriteLine(string.Join(" ", Q));
        }
    }
}